import Link from "next/link";
import ProgressBar from "./ProgressBar";

const SeoResut = ({seoResult, pageSpeed}) => {

  function calculateSpeedScore(loadTime) {
    const maxLoadTime = 10000;
  
    if (loadTime < 1500) {
      return 100;
    } 
  
    const speedScore = Math.max(0, 100 - ((loadTime - 1500) / (maxLoadTime - 1500)) * 100);
    return Math.floor(speedScore);
  }
  
  return (
    <div>
      <div className="relative pt-1">
        <div className="overflow-hidden h-2 mb-2 text-xs flex rounded bg-gray-400">
          <div style={{ width: `${(seoResult.data.metrics.pass / seoResult.data.metrics.total) * 100}%` }} className="shadow-none flex flex-col text-center whitespace-nowrap text-white justify-center bg-green-500"></div>
          <div style={{ width: `${(seoResult.data.metrics.fail / seoResult.data.metrics.total) * 100}%` }} className="shadow-none flex flex-col text-center whitespace-nowrap text-white justify-center bg-red-500"></div>
        </div>
        <div className="flex mb-4 items-center justify-between">
          <div>
            <span 
              className={`text-xs font-semibold inline-block py-1 px-2 uppercase rounded-md ${Math.round((seoResult.data.score / 100) * 100) > 85 ? "text-green-400 bg-green-400" : "text-red-400 bg-red-400"} bg-opacity-20`}>
              {Math.round((seoResult.data.score / 100) * 100) > 99 ? "Amazing" : (Math.round((seoResult.data.score / 100) * 100) > 85 ? "GOOD" : "Needs improvement")}
            </span>
          </div>
          <div className="text-right">
            <span className={`text-xs font-semibold inline-block ${Math.round((seoResult.data.metrics.pass / seoResult.data.metrics.total) * 100) > 85 ? "text-green-400" : "text-red-400"}`}>
              {Math.round((seoResult.data.score / 100) * 100)}%
            </span>
          </div>
        </div>
      </div>
      <ul>
        {Object.values(seoResult.checks).length > 0 ? (
          Object.values(seoResult.checks).map((check, index) => (
            <li key={index} className='mb-2'>
              <span className={`inline-block h-3 w-3 mr-2 rounded-full border border-2 ${check.result == "success" ? 'border-green-500' : 'border-red-500 '}`}></span>
              <span>{check.name}</span>
              {!!check.url && <Link className='text-blue-300 ml-2' href={check.url}>[read]</Link>}
            </li>
          ))
        ) : (
          <li>No errors found</li>
        )}
      </ul>
      <br />
      {pageSpeed && (
        <div>
          <h2 className='font-bold mb-2'>SPEED TEST</h2>
          <b className='mb-4 block border-b border-b-gray-600 py-2 text-gray-200'>Your Site</b>
          <ProgressBar percentage={(100 - calculateSpeedScore(seoResult.data.responseTime))} greenPercentage={14} orangePercentage={49} />
          <br />
          <Link className='text-blue-300 font-semibold' href={`/tutorials/response-time`}>Why is PageSpeed Important?</Link>
          <br />
          <p className='text-gray-400'>Website URL: {seoResult.data.url}</p>
          <p>Load Time: {seoResult.data.responseTime} ms</p>
          <br />
          <b className='mb-4 block border-b border-b-gray-600 py-2 text-gray-200'>Most Site's</b>
          <ProgressBar percentage={(100 - calculateSpeedScore(2800))} greenPercentage={14} orangePercentage={49} />
          <br />
          <p>Load Time: {2800} ms</p>
        </div>
      )}
    </div>
  )
}

export default SeoResut;