import React from 'react';

const ProgressBar = ({ percentage, greenPercentage, orangePercentage }) => {
  return (
    <div className='relative'>
      <div className="flex mb-4 items-center justify-between">
        <div>
          <span 
            className={`text-xs font-semibold inline-block py-1 px-2 uppercase rounded-md ${percentage < 15 ? "text-green-400 bg-green-400" : "text-red-400 bg-red-400"} bg-opacity-20`}>
            {percentage < 15 ? "Amazing" : (percentage < 50 ? "GOOD" : "Needs improvement")}
          </span>
        </div>
        <div className="text-right">
          <span className={`text-xs font-semibold inline-block ${percentage < 15 ? "text-green-400" : "text-red-400"}`}>
            {100 - percentage}%
          </span>
        </div>
      </div>
      <div className="relative w-full h-8 bg-red-600 rounded-full overflow-hidden">
        <div className='absolute top-0 left-0 h-full bg-transparent w-full'>
          <div className='inline-block bg-green-500 h-full' style={{ width: `${greenPercentage}%` }}></div>
          <div className='inline-block bg-orange-600 h-full' style={{ width: `${orangePercentage}%` }}></div>
        </div>
        <div
          className="absolute top-0 left-0 h-full bg-transparent-500 transition-width p-2"
          style={{ width: `${percentage < 4 ? 4.5 : (percentage > 98 ? 98.5 : percentage)}%` }}
        >
          <div className="w-5 h-5 bg-white rounded-full absolute top-1/2 transform -translate-y-1/2 right-0" />
        </div>
      </div>
    </div>
  );
};

export default ProgressBar;