import React, { useState, useEffect } from 'react';

const Progress = ({ percent }) => {
  const [color, setColor] = useState('red'); // Default color: red
  const [rgb, setRgb] = useState('red'); // Default color: red

  useEffect(() => {
    if (percent > 49 && percent <= 90) {
      setColor("orange");
      setRgb(`rgba(255, 165, 0, 0.3)`); // Orange color for progress between 50 and 90
    } else if (percent > 90) {
      setColor('#00c251');
      setRgb(`rgba(0, 128, 0, 0.3)`); // Green color for progress above 90
    } else {
      setColor('#FF0000');
      setRgb(`rgba(255, 0, 0, 0.3)`); // Default color: red
    }
  }, [percent, setColor]);

  return (
    <div className="relative w-24 h-24">
      <div className="rounded-full border-4 border-gray-400 w-full h-full" style={{borderColor: color, background: rgb}} />
      <div className="absolute inset-0 flex items-center justify-center">
        <span className="font-bold text-3xl" style={{color: color}}>{percent}</span>
      </div>
    </div>
  );
};

export default Progress;