import { NextResponse } from 'next/server'

export async function GET(req) {
  const searchParams = new URLSearchParams(req.nextUrl.searchParams);
  const url = searchParams.get("url");

  if (!url) {
    return NextResponse.json({ error: 'Missing URL parameter' }, { status: 400 });
  }

  const options = {
    method: 'GET',
    headers: {
      'X-RapidAPI-Key': process.env.SEOX_APIKEY,
      'X-RapidAPI-Host': 'seox.p.rapidapi.com'
    }
  };

  try {
    const response = await fetch(`https://seox.p.rapidapi.com/api/seo?url=${url}`, options);
    const data = await response.json();
    return NextResponse.json(data, { status: 500 });
  } catch (error) {
    console.error('Error analyzing SEO:', error);
    return NextResponse.json({ error: 'Internal Server Error' }, { status: 500 });
  }
}
